/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;
import net.montoyo.wd.block.BlockKeyboardRight;
import net.montoyo.wd.block.BlockPeripheral;
import net.montoyo.wd.core.DefaultPeripheral;
import net.montoyo.wd.entity.TileEntityKeyboard;
import net.montoyo.wd.item.ItemLinker;
import net.montoyo.wd.net.WDNetworkRegistry;
import net.montoyo.wd.net.client_bound.S2CMessageCloseGui;
import org.jetbrains.annotations.NotNull;

public class BlockKeyboardLeft
extends BlockPeripheral {
    public static final EnumProperty<DefaultPeripheral> TYPE = EnumProperty.m_61587_((String)"type", DefaultPeripheral.class);
    public static final DirectionProperty FACING = DirectionProperty.m_61549_((String)"facing", (Direction[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST});
    public static final VoxelShape[] KEYBOARD_AABBS = new VoxelShape[]{Shapes.m_83048_((double)0.0, (double)0.0, (double)0.1875, (double)1.0, (double)0.0625, (double)1.0), Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)0.8125), Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0), Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.8125, (double)0.0625, (double)1.0)};
    private static final Property<?>[] properties = new Property[]{TYPE, FACING};

    public BlockKeyboardLeft() {
        super(DefaultPeripheral.KEYBOARD);
    }

    public static TileEntityKeyboard getTileEntity(BlockState state, Level world, BlockPos pos) {
        BlockEntity te;
        BlockEntity te2;
        if (state.m_60734_() instanceof BlockKeyboardLeft && (te2 = world.m_7702_(pos)) instanceof TileEntityKeyboard) {
            return (TileEntityKeyboard)te2;
        }
        BlockPos relative = pos.m_121945_(BlockKeyboardLeft.mapDirection(((Direction)state.m_61143_((Property)FACING)).m_122424_()));
        BlockState ns = world.m_8055_(relative);
        if (ns.m_60734_() instanceof BlockPeripheral && (te = world.m_7702_(relative)) instanceof TileEntityKeyboard) {
            return (TileEntityKeyboard)te;
        }
        return null;
    }

    public static Direction mapDirection(Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> Direction.EAST;
            case Direction.EAST -> Direction.SOUTH;
            case Direction.SOUTH -> Direction.WEST;
            case Direction.WEST -> Direction.NORTH;
            default -> facing;
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(properties);
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        TileEntityKeyboard tek;
        double rpos = (entity.m_20186_() - (double)pos.m_123342_()) * 16.0;
        if (!world.f_46443_ && rpos >= 1.0 && rpos <= 2.0 && Math.random() < 0.25 && (tek = BlockKeyboardLeft.getTileEntity(state, world, pos)) != null) {
            tek.simulateCat(entity);
        }
    }

    @Override
    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_21120_(hand).m_41720_() instanceof ItemLinker) {
            return InteractionResult.PASS;
        }
        TileEntityKeyboard tek = BlockKeyboardLeft.getTileEntity(state, level, pos);
        if (tek != null) {
            return tek.onRightClick(player, hand);
        }
        return InteractionResult.PASS;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return KEYBOARD_AABBS[((Direction)state.m_61143_((Property)FACING)).ordinal() - 2];
    }

    public VoxelShape m_7952_(BlockState arg, BlockGetter arg2, BlockPos arg3) {
        return Shapes.m_83040_();
    }

    private static void removeRightPiece(BlockState state, Level world, BlockPos pos) {
        BlockPos relative = pos.m_121945_(BlockKeyboardLeft.mapDirection((Direction)state.m_61143_((Property)FACING)));
        BlockState ns = world.m_8055_(relative);
        if (ns.m_60734_() instanceof BlockKeyboardRight) {
            world.m_7731_(relative, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    public static void remove(BlockState state, Level world, BlockPos pos, boolean setState, boolean drop) {
        BlockKeyboardLeft.removeRightPiece(state, world, pos);
        if (setState) {
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
        WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockKeyboardLeft.point(world, pos)), (Object)new S2CMessageCloseGui(pos));
    }

    public void m_6810_(BlockState arg, Level arg2, BlockPos arg3, BlockState arg4, boolean bl) {
        if (!arg2.f_46443_) {
            BlockKeyboardLeft.remove(arg, arg2, arg3, false, false);
        }
        super.m_6810_(arg, arg2, arg3, arg4, bl);
    }
}

